#pragma once

#include <drive/backend/incident/constants.h>
#include <drive/backend/incident/incident_context.h>

#include <drive/backend/abstract/localization.h>

#include <library/cpp/json/json_value.h>

#include <rtline/util/types/accessor.h>

namespace NDrive {
    class TIncidentTicketIncidentContext: public IIncidentContext {
        using TDynamicContext = TMap<TString, TString>;

        FACTORY_INCIDENT_CONTEXT(TIncidentTicketIncidentContext, EIncidentContextType::IncidentTicket);

    public:
        static NDrive::TScheme GetScheme(const IServerBase& server, const TMaybe<EIncidentType>& incidentType, TPtr existingContextPtr);
        static void InitializeLocalizedVariants(const IServerBase& server, TDynamicContext& dynamicContext, const ELocalization locale);

        TMaybe<EIncidentType> GetIncidentType() const;

    private:
        virtual NJson::TJsonValue DoSerializeToJson() const override;
        virtual bool DoDeserializeFromJson(const NJson::TJsonValue& data, TMessagesCollector& errors) override;

    private:
        R_READONLY(NJson::TJsonValue, Data);
    };
}
