#include "renins_kasko_claim.h"

#include <drive/backend/incident/renins_claims/claim_entity_kasko.h>

#include <drive/backend/abstract/base.h>

#include <drive/library/cpp/scheme/scheme.h>

#include <rtline/util/algorithm/ptr.h>

namespace NDrive {
    TReninsKaskoClaimIncidentContext::TRegistrator TReninsKaskoClaimIncidentContext::Registrator;

    TReninsKaskoClaimIncidentContext::TReninsKaskoClaimIncidentContext()
        : ClaimEntryPtr(MakeAtomicShared<NDrive::NRenins::TKaskoClaimEntry>())
    {
    }

    NDrive::TScheme TReninsKaskoClaimIncidentContext::GetScheme(const IServerBase& server, const TMaybe<EIncidentType>& /* incidentType */, TPtr existingContextPtr) {
        auto ctx = std::dynamic_pointer_cast<TReninsKaskoClaimIncidentContext>(existingContextPtr);
        const auto& entry = ctx ? TMaybe<NDrive::NRenins::TKaskoClaimEntry>(*(ctx->GetClaimEntryPtr())) : Nothing();
        return NDrive::NRenins::TKaskoClaimEntry::GetScheme(server, entry);
    }

    NJson::TJsonValue TReninsKaskoClaimIncidentContext::DoSerializeToJson() const {
        return ClaimEntryPtr->SerializeToJson();
    }

    bool TReninsKaskoClaimIncidentContext::DoDeserializeFromJson(const NJson::TJsonValue& data, TMessagesCollector& /* errors */) {
        return ClaimEntryPtr->DeserializeFromJson(data);
    }
}
