#pragma once

#include <drive/backend/incident/constants.h>
#include <drive/backend/incident/incident_context.h>

#include <rtline/util/types/accessor.h>

namespace NDrive::NRenins {
    class TKaskoClaimEntry;
}

namespace NDrive {
    class TReninsKaskoClaimIncidentContext: public IIncidentContext {
        FACTORY_INCIDENT_CONTEXT(TReninsKaskoClaimIncidentContext, EIncidentContextType::ReninsKaskoClaim);

    public:
        TReninsKaskoClaimIncidentContext();

        static NDrive::TScheme GetScheme(const IServerBase& server, const TMaybe<EIncidentType>& incidentType, TPtr existingContextPtr);

    private:
        virtual NJson::TJsonValue DoSerializeToJson() const override;
        virtual bool DoDeserializeFromJson(const NJson::TJsonValue& data, TMessagesCollector& errors) override;

    private:
        R_READONLY(TAtomicSharedPtr<NDrive::NRenins::TKaskoClaimEntry>, ClaimEntryPtr);
    };
}
