#include "incident_context.h"

#include <drive/backend/abstract/base.h>

#include <drive/library/cpp/scheme/scheme.h>

#include <rtline/library/json/adapters.h>
#include <rtline/library/json/parse.h>

#include <util/string/cast.h>

namespace NDrive {
    IIncidentContext::TPtr IIncidentContext::Construct(const EIncidentContextType contextType, const NJson::TJsonValue& data, TMessagesCollector& errors) {
        TPtr instancePtr = TFactory::Construct(contextType);
        if (!instancePtr || !instancePtr->DeserializeFromJson(data, errors)) {
            return nullptr;
        }
        return instancePtr;
    }

    IIncidentContext::TPtr IIncidentContext::Construct(const NJson::TJsonValue& data, TMessagesCollector& errors) {
        EIncidentContextType contextType;
        if (!NJson::ParseField(data["context_type"], NJson::Stringify(contextType), /* required = */ true, errors)) {
            return nullptr;
        }
        return Construct(contextType, data, errors);
    }

    TString IIncidentContext::GetType() const {
        return ::ToString(GetContextType());
    }

    NDrive::TScheme IIncidentContext::GetScheme(const IServerBase& /* server */, const TMaybe<EIncidentType>& /* incidentType */, TPtr /* existingContextPtr */) {
        return {};
    }

    NJson::TJsonValue IIncidentContext::SerializeToJson() const {
        auto result = DoSerializeToJson();
        result["context_type"] = GetType();  // add explicitly or overwrite (cannot be other than target type if exists as it could not be deserialized properly then)
        return result;
    }

    bool IIncidentContext::DeserializeFromJson(const NJson::TJsonValue& data, TMessagesCollector& errors) {
        if (data.Has("context_type")) {
            EIncidentContextType contextType;
            if (!NJson::ParseField(data["context_type"], NJson::Stringify(contextType), /* required = */ true, errors) || contextType != GetContextType()) {
                return false;
            }
        }
        return DoDeserializeFromJson(data, errors);
    }
}
