#pragma once

#include "constants.h"

#include <library/cpp/json/json_value.h>
#include <library/cpp/object_factory/object_factory.h>

#include <rtline/util/types/accessor.h>
#include <rtline/util/types/messages_collector.h>

class IServerBase;

namespace NDrive {
    class TScheme;
}

namespace NDrive {
    #define FACTORY_INCIDENT_CONTEXT(ClassName, EnumValue)                \
    public:                                                               \
        using TRegistrator = TFactory::TRegistrator<ClassName>;           \
        static EIncidentContextType GetTypeName() {                       \
            return (EnumValue);                                           \
        }                                                                 \
        virtual EIncidentContextType GetContextType() const override {    \
            return (EnumValue);                                           \
        }                                                                 \
    private:                                                              \
        static TRegistrator Registrator;

    class IIncidentContext {
    public:
        using TPtr = TAtomicSharedPtr<IIncidentContext>;
        using TFactory = NObjectFactory::TParametrizedObjectFactory<IIncidentContext, EIncidentContextType>;

        virtual ~IIncidentContext() = default;

        static TPtr Construct(const EIncidentContextType contextType, const NJson::TJsonValue& data, TMessagesCollector& errors);
        static TPtr Construct(const NJson::TJsonValue& data, TMessagesCollector& errors);

        TString GetType() const;
        virtual EIncidentContextType GetContextType() const = 0;

        static NDrive::TScheme GetScheme(const IServerBase& server, const TMaybe<EIncidentType>& incidentType, TPtr existingContextPtr);

        NJson::TJsonValue SerializeToJson() const;
        bool DeserializeFromJson(const NJson::TJsonValue& data, TMessagesCollector& errors);

    private:
        virtual NJson::TJsonValue DoSerializeToJson() const = 0;
        virtual bool DoDeserializeFromJson(const NJson::TJsonValue& data, TMessagesCollector& errors) = 0;
    };
};
