#include "catalogue_entity_osago.h"

#include <util/string/cast.h>
#include <util/string/join.h>

namespace NDrive::NRenins {
    TOsagoAccidentSchemeEntry::TRegistrator TOsagoAccidentSchemeEntry::Registrator;
    TOsagoAccidentSchemePositionEntry::TRegistrator TOsagoAccidentSchemePositionEntry::Registrator;
    TOsagoCountryEntry::TRegistrator TOsagoCountryEntry::Registrator;
    TOsagoDamageClassificationEntry::TRegistrator TOsagoDamageClassificationEntry::Registrator;
    TOsagoDamageListEntry::TRegistrator TOsagoDamageListEntry::Registrator;
    TOsagoDamageTypeEntry::TRegistrator TOsagoDamageTypeEntry::Registrator;
    TOsagoDocumentTypeEntry::TRegistrator TOsagoDocumentTypeEntry::Registrator;
    TOsagoFinCoprClientLegalFormEntry::TRegistrator TOsagoFinCoprClientLegalFormEntry::Registrator;
    TOsagoLocationTypeEntry::TRegistrator TOsagoLocationTypeEntry::Registrator;
    TOsagoLossCodeEntry::TRegistrator TOsagoLossCodeEntry::Registrator;
    TOsagoPersonDocumentTypeEntry::TRegistrator TOsagoPersonDocumentTypeEntry::Registrator;
    TOsagoPropertyTypeEntry::TRegistrator TOsagoPropertyTypeEntry::Registrator;
    TOsagoRegistrationChannelEntry::TRegistrator TOsagoRegistrationChannelEntry::Registrator;
    TOsagoRegistrationTypeEntry::TRegistrator TOsagoRegistrationTypeEntry::Registrator;
    TOsagoRegulationTypeEntry::TRegistrator TOsagoRegulationTypeEntry::Registrator;
    TOsagoReportingMethodEntry::TRegistrator TOsagoReportingMethodEntry::Registrator;
    TOsagoRFSubjectEntry::TRegistrator TOsagoRFSubjectEntry::Registrator;
    TOsagoRoleEntry::TRegistrator TOsagoRoleEntry::Registrator;
    TOsagoSTOAAddressEntry::TRegistrator TOsagoSTOAAddressEntry::Registrator;
    TOsagoTerritoryEntry::TRegistrator TOsagoTerritoryEntry::Registrator;
    TOsagoVehicleColorEntry::TRegistrator TOsagoVehicleColorEntry::Registrator;
    TOsagoVehicleDocumentTypeEntry::TRegistrator TOsagoVehicleDocumentTypeEntry::Registrator;
    TOsagoVehicleModelEntry::TRegistrator TOsagoVehicleModelEntry::Registrator;
    TOsagoVehicleRoleEntry::TRegistrator TOsagoVehicleRoleEntry::Registrator;
    TOsagoVehicleTypeEntry::TRegistrator TOsagoVehicleTypeEntry::Registrator;
    TOsagoViolatedPDDRuleEntry::TRegistrator TOsagoViolatedPDDRuleEntry::Registrator;

    EClaimType IOsagoCatalogueEntry::GetClaimTypeName() {
        return EClaimType::Osago;
    }

    TString IOsagoCatalogueEntry::GetSettingPrefix() {
        return JoinSeq(".", {OsagoSettingPrefix, TStringBuf("catalogue_values")});
    }

    TString IOsagoCatalogueEntry::GetClaimType() const {
        return ::ToString(GetClaimTypeName());
    }

    TString IOsagoCatalogueEntry::GetSettingKey() const {
        return JoinSeq(".", {GetSettingPrefix(), GetType()});
    }

    NJson::TJsonValue TOsagoDocumentTypeEntry::MakeRequestData(const TReninsClaimClientConfig& /* config */) const {
        return {};
    }

    bool TOsagoDocumentTypeEntry::ParseResponse(const NJson::TJsonValue& /* data */) {
        return false;
    }

    bool TOsagoLossCodeEntry::ParseResponse(const NJson::TJsonValue& /* data */) {
        return false;
    }

    NJson::TJsonValue TOsagoLossCodeEntry::SerializeToJson() const {
        return {};
    }

    bool TOsagoLossCodeEntry::DeserializeFromJson(const NJson::TJsonValue& /* data */) {
        return false;
    }

    TOsagoLossCodeEntry::operator TFSVariants::TCompoundVariants() const {
        return TFSVariants::TCompoundVariants();
    }

    bool TOsagoSTOAAddressEntry::ParseResponse(const NJson::TJsonValue& /* data */) {
        return false;
    }

    NJson::TJsonValue TOsagoSTOAAddressEntry::SerializeToJson() const {
        return {};
    }

    bool TOsagoSTOAAddressEntry::DeserializeFromJson(const NJson::TJsonValue& /* data */) {
        return false;
    }

    TOsagoSTOAAddressEntry::operator TFSVariants::TCompoundVariants() const {
        return TFSVariants::TCompoundVariants();
    }

    bool TOsagoVehicleModelEntry::ParseResponse(const NJson::TJsonValue& /* data */) {
        return false;
    }

    NJson::TJsonValue TOsagoVehicleModelEntry::SerializeToJson() const {
        return {};
    }

    bool TOsagoVehicleModelEntry::DeserializeFromJson(const NJson::TJsonValue& /* data */) {
        return false;
    }

    TOsagoVehicleModelEntry::operator TFSVariants::TCompoundVariants() const {
        return TFSVariants::TCompoundVariants();
    }
}
