#pragma once

#include "catalogue_entity_base.h"

namespace NDrive::NRenins {
    class IOsagoCatalogueEntry: virtual public ICatalogueEntry {
    public:
        using TFactory = NObjectFactory::TParametrizedObjectFactory<IOsagoCatalogueEntry, EOsagoCatalogueType>;

        static EClaimType GetClaimTypeName();
        static TString GetSettingPrefix();

        virtual TString GetClaimType() const override;
        virtual TString GetSettingKey() const override;
    };

    class TOsagoAccidentSchemeEntry: public IOsagoCatalogueEntry, public IMappedCatalogueEntry {
        FACTORY_RENINS_CATALOGUE_ENTRY(TOsagoAccidentSchemeEntry, EOsagoCatalogueType::AccidentScheme);
    };

    class TOsagoAccidentSchemePositionEntry: public IOsagoCatalogueEntry, public ISeriesCatalogueEntry {
        FACTORY_RENINS_CATALOGUE_ENTRY(TOsagoAccidentSchemePositionEntry, EOsagoCatalogueType::AccidentSchemePosition);
    };

    class TOsagoCountryEntry: public IOsagoCatalogueEntry, public ISeriesCatalogueEntry {
        FACTORY_RENINS_CATALOGUE_ENTRY(TOsagoCountryEntry, EOsagoCatalogueType::Country);
    };

    class TOsagoDamageClassificationEntry: public IOsagoCatalogueEntry, public ISeriesCatalogueEntry {
        FACTORY_RENINS_CATALOGUE_ENTRY(TOsagoDamageClassificationEntry, EOsagoCatalogueType::DamageClassification);
    };

    class TOsagoDamageListEntry: public IOsagoCatalogueEntry, public ISeriesCatalogueEntry {
        FACTORY_RENINS_CATALOGUE_ENTRY(TOsagoDamageListEntry, EOsagoCatalogueType::DamageList);
    };

    class TOsagoDamageTypeEntry: public IOsagoCatalogueEntry, public ISeriesCatalogueEntry {
        FACTORY_RENINS_CATALOGUE_ENTRY(TOsagoDamageTypeEntry, EOsagoCatalogueType::DamageType);
    };

    class TOsagoDocumentTypeEntry: public IOsagoCatalogueEntry, public IMappedCatalogueEntry {
        FACTORY_RENINS_CATALOGUE_ENTRY(TOsagoDocumentTypeEntry, EOsagoCatalogueType::DocumentType);

    public:
        virtual NJson::TJsonValue MakeRequestData(const TReninsClaimClientConfig& config) const override;
        virtual bool ParseResponse(const NJson::TJsonValue& data) override;
    };

    class TOsagoFinCoprClientLegalFormEntry: public IOsagoCatalogueEntry, public IMappedCatalogueEntry {
        FACTORY_RENINS_CATALOGUE_ENTRY(TOsagoFinCoprClientLegalFormEntry, EOsagoCatalogueType::FinCoprClientLegalForm);
    };

    class TOsagoLocationTypeEntry: public IOsagoCatalogueEntry, public ISeriesCatalogueEntry {
        FACTORY_RENINS_CATALOGUE_ENTRY(TOsagoLocationTypeEntry, EOsagoCatalogueType::LocationType);
    };

    class TOsagoLossCodeEntry: public IOsagoCatalogueEntry {
        FACTORY_RENINS_CATALOGUE_ENTRY(TOsagoLossCodeEntry, EOsagoCatalogueType::LossCode);

    public:
        virtual bool ParseResponse(const NJson::TJsonValue& data) override;

        virtual NJson::TJsonValue SerializeToJson() const override;
        virtual bool DeserializeFromJson(const NJson::TJsonValue& data) override;

        virtual operator TFSVariants::TCompoundVariants() const override;
    };

    class TOsagoPersonDocumentTypeEntry: public IOsagoCatalogueEntry, public ISeriesCatalogueEntry {
        FACTORY_RENINS_CATALOGUE_ENTRY(TOsagoPersonDocumentTypeEntry, EOsagoCatalogueType::PersonDocumentType);
    };

    class TOsagoPropertyTypeEntry: public IOsagoCatalogueEntry, public ISeriesCatalogueEntry {
        FACTORY_RENINS_CATALOGUE_ENTRY(TOsagoPropertyTypeEntry, EOsagoCatalogueType::PropertyType);
    };

    class TOsagoRegistrationChannelEntry: public IOsagoCatalogueEntry, public ISeriesCatalogueEntry {
        FACTORY_RENINS_CATALOGUE_ENTRY(TOsagoRegistrationChannelEntry, EOsagoCatalogueType::RegistrationChannel);
    };

    class TOsagoRegistrationTypeEntry: public IOsagoCatalogueEntry, public ISeriesCatalogueEntry {
        FACTORY_RENINS_CATALOGUE_ENTRY(TOsagoRegistrationTypeEntry, EOsagoCatalogueType::RegistrationType);
    };

    class TOsagoRegulationTypeEntry: public IOsagoCatalogueEntry, public ISeriesCatalogueEntry {
        FACTORY_RENINS_CATALOGUE_ENTRY(TOsagoRegulationTypeEntry, EOsagoCatalogueType::RegulationType);
    };

    class TOsagoReportingMethodEntry: public IOsagoCatalogueEntry, public ISeriesCatalogueEntry {
        FACTORY_RENINS_CATALOGUE_ENTRY(TOsagoReportingMethodEntry, EOsagoCatalogueType::ReportingMethod);
    };

    class TOsagoRFSubjectEntry: public IOsagoCatalogueEntry, public ISeriesCatalogueEntry {
        FACTORY_RENINS_CATALOGUE_ENTRY(TOsagoRFSubjectEntry, EOsagoCatalogueType::RFSubject);
    };

    class TOsagoRoleEntry: public IOsagoCatalogueEntry, public ISeriesCatalogueEntry {
        FACTORY_RENINS_CATALOGUE_ENTRY(TOsagoRoleEntry, EOsagoCatalogueType::Role);
    };

    class TOsagoSTOAAddressEntry: public IOsagoCatalogueEntry {
        FACTORY_RENINS_CATALOGUE_ENTRY(TOsagoSTOAAddressEntry, EOsagoCatalogueType::STOAAddress);

    public:
        virtual bool ParseResponse(const NJson::TJsonValue& data) override;

        virtual NJson::TJsonValue SerializeToJson() const override;
        virtual bool DeserializeFromJson(const NJson::TJsonValue& data) override;

        virtual operator TFSVariants::TCompoundVariants() const override;
    };

    class TOsagoTerritoryEntry: public IOsagoCatalogueEntry, public ISeriesCatalogueEntry {
        FACTORY_RENINS_CATALOGUE_ENTRY(TOsagoTerritoryEntry, EOsagoCatalogueType::Territory);
    };

    class TOsagoVehicleColorEntry: public IOsagoCatalogueEntry, public ISeriesCatalogueEntry {
        FACTORY_RENINS_CATALOGUE_ENTRY(TOsagoVehicleColorEntry, EOsagoCatalogueType::VehicleColor);
    };

    class TOsagoVehicleDocumentTypeEntry: public IOsagoCatalogueEntry, public IMappedCatalogueEntry {
        FACTORY_RENINS_CATALOGUE_ENTRY(TOsagoVehicleDocumentTypeEntry, EOsagoCatalogueType::VehicleDocumentType);
    };

    class TOsagoVehicleModelEntry: public IOsagoCatalogueEntry {
        FACTORY_RENINS_CATALOGUE_ENTRY(TOsagoVehicleModelEntry, EOsagoCatalogueType::VehicleModel);

    public:
        virtual bool ParseResponse(const NJson::TJsonValue& data) override;

        virtual NJson::TJsonValue SerializeToJson() const override;
        virtual bool DeserializeFromJson(const NJson::TJsonValue& data) override;

        virtual operator TFSVariants::TCompoundVariants() const override;
    };

    class TOsagoVehicleRoleEntry: public IOsagoCatalogueEntry, public ISeriesCatalogueEntry {
        FACTORY_RENINS_CATALOGUE_ENTRY(TOsagoVehicleRoleEntry, EOsagoCatalogueType::VehicleRole);
    };

    class TOsagoVehicleTypeEntry: public IOsagoCatalogueEntry, public ISeriesCatalogueEntry {
        FACTORY_RENINS_CATALOGUE_ENTRY(TOsagoVehicleTypeEntry, EOsagoCatalogueType::VehicleType);
    };

    class TOsagoViolatedPDDRuleEntry: public IOsagoCatalogueEntry, public IMappedCatalogueEntry {
        FACTORY_RENINS_CATALOGUE_ENTRY(TOsagoViolatedPDDRuleEntry, EOsagoCatalogueType::ViolatedPDDRule);
    };
}
