#pragma once

#include "catalogue_entity_kasko.h"
#include "common_entity.h"
#include "config.h"
#include "entity_base.h"

class TMessagesCollector;

namespace NDrive::NRenins {
    class TKaskoGeneralClaimInfo: public IRequestInfoEntry {
    public:
        static NDrive::TScheme GetScheme(const IServerBase& server, const TMaybe<TKaskoGeneralClaimInfo>& entry = {});

        virtual NJson::TJsonValue MakeRequestData(const TReninsClaimClientConfig& config) const override;
        virtual bool ParseResponse(const NJson::TJsonValue& data) override;

        virtual NJson::TJsonValue SerializeToJson() const override;
        virtual bool DeserializeFromJson(const NJson::TJsonValue& data) override;

    private:
        R_FIELD(TString, PartnerRole);
        R_FIELD(bool, DoRegisterClaim, true);
    };

    class TKaskoClaim: public IRequestInfoEntry {
    public:
        static NDrive::TScheme GetScheme(const IServerBase& server, const TMaybe<TKaskoClaim>& entry = {});

        virtual NJson::TJsonValue MakeRequestData(const TReninsClaimClientConfig& config) const override;
        virtual bool ParseResponse(const NJson::TJsonValue& data) override;

        virtual NJson::TJsonValue SerializeToJson() const override;
        virtual bool DeserializeFromJson(const NJson::TJsonValue& data) override;

    private:
        R_FIELD(TString, PolicyNumber);
        R_FIELD(TString, ClaimNumber);
        R_FIELD(TInstant, IncidentTimestamp);
        R_FIELD(TKaskoLossCodeInfo, LossCodeInfo);
        R_FIELD(TString, Location);
        R_FIELD(TString, ResponsiblePerson);
        R_FIELD(TString, PlaceType);
        R_FIELD(TString, Town);
        R_FIELD(TString, Address);
        R_FIELD(TInstant, NotificationTimestamp);
        R_FIELD(TInstant, RegistrationTimestamp);
        R_FIELD(TString, RegistrationType);
        R_OPTIONAL(bool, IsEuroprotocol);
        R_FIELD(TInstant, InquiryDate);
        R_FIELD(bool, HasInjuredPersons, false);
        R_FIELD(bool, HasLostPersons, false);
        R_OPTIONAL(bool, HasMultipleDamageFaces);
        R_FIELD(bool, OnTheMove, false);
        R_FIELD(TString, RegulationType);
        R_FIELD(TString, AdditionalInfo);
    };

    class TKaskoPolicy: public IRequestInfoEntry {
    public:
        static NDrive::TScheme GetScheme(const IServerBase& server, const TMaybe<TKaskoPolicy>& entry = {});

        virtual NJson::TJsonValue MakeRequestData(const TReninsClaimClientConfig& config) const override;
        virtual bool ParseResponse(const NJson::TJsonValue& data) override;

        virtual NJson::TJsonValue SerializeToJson() const override;
        virtual bool DeserializeFromJson(const NJson::TJsonValue& data) override;

        explicit operator bool() const;

    private:
        R_FIELD(TString, InsuranceCompany);
        R_FIELD(TString, Address);
        R_FIELD(TInstant, PolicyStartDate);
        R_FIELD(TInstant, PolicyEndDate);
        R_FIELD(TString, PolicyNumber);
    };

    class TKaskoDeclarant: public IRequestInfoEntry {
    public:
        static NDrive::TScheme GetScheme(const IServerBase& server, const TMaybe<TKaskoDeclarant>& entry = {});

        virtual NJson::TJsonValue MakeRequestData(const TReninsClaimClientConfig& config) const override;
        virtual bool ParseResponse(const NJson::TJsonValue& data) override;

        virtual NJson::TJsonValue SerializeToJson() const override;
        virtual bool DeserializeFromJson(const NJson::TJsonValue& data) override;

    private:
        R_FIELD(TString, LastName);
        R_FIELD(TString, FirstName);
        R_FIELD(TString, MiddleName);
        R_FIELD(TString, Email);
        R_FIELD(TString, EmergencyPhoneNumber);
        R_FIELD(TString, Address);
        R_FIELD(TString, RoleInAccident);
        R_FIELD(TString, BirthDate);
        R_FIELD(TString, ExperienceYear);
        R_FIELD(TKaskoPolicy, PolicyOsagoDeclarant);
    };

    class TKaskoParticipant: public IRequestInfoEntry {
    public:
        static NDrive::TScheme GetScheme(const IServerBase& server, const TMaybe<TKaskoParticipant>& entry = {});

        virtual NJson::TJsonValue MakeRequestData(const TReninsClaimClientConfig& config) const override;
        virtual bool ParseResponse(const NJson::TJsonValue& data) override;

        virtual NJson::TJsonValue SerializeToJson() const override;
        virtual bool DeserializeFromJson(const NJson::TJsonValue& data) override;

    private:
        R_FIELD(TString, RoleInAccident);
        R_FIELD(TString, LastName);
        R_FIELD(TString, FirstName);
        R_FIELD(TString, MiddleName);
        R_FIELD(TString, Email);
        R_FIELD(TString, EmergencyPhoneNumber);
        R_FIELD(TString, BirthDate);
        R_FIELD(TString, ExperienceYear);
        R_FIELD(TString, Address);
        R_OPTIONAL(bool, IsGuilty);
        R_OPTIONAL(bool, IsBeneficiary);
        R_OPTIONAL(bool, IsMediator);
        R_OPTIONAL(bool, IsInjured);
        R_FIELD(TKaskoPolicy, PolicyOsagoParticipant);
    };

    class TKaskoVehicle: public IRequestInfoEntry {
    public:
        static NDrive::TScheme GetScheme(const IServerBase& server, const TMaybe<TKaskoVehicle>& entry = {});

        virtual NJson::TJsonValue MakeRequestData(const TReninsClaimClientConfig& config) const override;
        virtual bool ParseResponse(const NJson::TJsonValue& data) override;

        virtual NJson::TJsonValue SerializeToJson() const override;
        virtual bool DeserializeFromJson(const NJson::TJsonValue& data) override;

    private:
        R_FIELD(TString, PlateNumber);
        R_FIELD(TString, Color);
        R_FIELD(TString, VIN);
        R_FIELD(TString, PTSNumber);
        R_FIELD(bool, IsTransportable, true);
        R_FIELD(TInstant, OfficialInspectionDate);
        R_OPTIONAL(bool, NoTruckNeeded);
        R_FIELD(double, ReserveAmount, 0.0);
    };

    class TKaskoDamages: public IRequestInfoEntry {
    public:
        static NDrive::TScheme GetScheme(const IServerBase& server, const TMaybe<TKaskoDamages>& entry = {});

        virtual NJson::TJsonValue MakeRequestData(const TReninsClaimClientConfig& config) const override;
        virtual bool ParseResponse(const NJson::TJsonValue& data) override;

        virtual NJson::TJsonValue SerializeToJson() const override;
        virtual bool DeserializeFromJson(const NJson::TJsonValue& data) override;

    private:
        R_FIELD(TSet<TString>, Damages);
    };

    class TKaskoSTOAInfo: public IRequestInfoEntry {
    public:
        static NDrive::TScheme GetScheme(const IServerBase& server, const TMaybe<TKaskoSTOAInfo>& entry = {});

        virtual NJson::TJsonValue MakeRequestData(const TReninsClaimClientConfig& config) const override;
        virtual bool ParseResponse(const NJson::TJsonValue& data) override;

        virtual NJson::TJsonValue SerializeToJson() const override;
        virtual bool DeserializeFromJson(const NJson::TJsonValue& data) override;

    private:
        R_FIELD(TKaskoSTOAAddressInfo, STOAAddressInfo);
    };

    class TKaskoReserveAmountInfo: public IRequestInfoEntry {
    public:
        static NDrive::TScheme GetScheme(const IServerBase& server, const TMaybe<TKaskoReserveAmountInfo>& entry = {});

        virtual NJson::TJsonValue MakeRequestData(const TReninsClaimClientConfig& config) const override;
        virtual bool ParseResponse(const NJson::TJsonValue& data) override;

        virtual NJson::TJsonValue SerializeToJson() const override;
        virtual bool DeserializeFromJson(const NJson::TJsonValue& data) override;

    private:
        R_FIELD(double, Amount, 0.0);
    };

    class TKaskoClaimEntry: public IRequestEntry {
    public:
        static NDrive::TScheme GetScheme(const IServerBase& server, const TMaybe<TKaskoClaimEntry>& entry = {}, bool useTabs = false);

        virtual NJson::TJsonValue MakeRequestData(const TReninsClaimClientConfig& config) const override;
        virtual bool ParseResponse(const NJson::TJsonValue& data) override;

        virtual NJson::TJsonValue SerializeToJson() const override;
        virtual bool DeserializeFromJson(const NJson::TJsonValue& data) override;

        virtual bool Validate(TMessagesCollector& errors) const override;

        bool IsInitialClaimApplication() const;

    private:
        R_FIELD(TKaskoGeneralClaimInfo, GeneralClaimInfo);
        R_FIELD(TKaskoClaim, Claim);
        R_FIELD(TKaskoDeclarant, Declarant);
        R_FIELD(TVector<TKaskoParticipant>, Participants);
        R_FIELD(TKaskoVehicle, VehicleDescription);
        R_FIELD(TKaskoDamages, Damages);
        R_FIELD(TKaskoSTOAInfo, STOAInfo);
        R_FIELD(TKaskoReserveAmountInfo, ReserveAmountInfo);
        R_FIELD(TDocuments, Documents);
    };
}
