#pragma once

#include "catalogue_entity_kasko.h"
#include "catalogue_entity_osago.h"
#include "claim_entity_kasko.h"
#include "common_entity.h"
#include "config.h"
#include "entity_base.h"
#include "logger.h"

#include <library/cpp/json/json_value.h>

#include <rtline/library/deprecated/async_impl/client.h>

class TSimpleHttpClient;

namespace NDrive::NRenins {
    class TReninsClaimClient: public TRequestClient<TReninsClaimClientConfig, TReninsClaimLogger> {
        using TBase = TRequestClient<TReninsClaimClientConfig, TReninsClaimLogger>;

    public:
        explicit TReninsClaimClient(const TReninsClaimClientConfig& config);
        ~TReninsClaimClient();

        NThreading::TFuture<void> ReportKaskoAsync(TKaskoClaimEntry& requestEntry) const;
        bool ReportKaskoSync(TKaskoClaimEntry& requestEntry, TMessagesCollector& errors) const;

        NThreading::TFuture<void> UploadDocumentsAsync(TDocumentsEntry& requestEntry) const;
        bool UploadDocumentsSync(TDocumentsEntry& requestEntry, TMessagesCollector& errors) const;

        NThreading::TFuture<void> GetCatalogueValuesAsync(ICatalogueEntry& requestEntry) const;
        bool GetCatalogueValuesSync(ICatalogueEntry& requestEntry, TMessagesCollector& errors) const;

        NThreading::TFuture<void> GetSTOAAddressesAsync(ICatalogueEntry& requestEntry) const;
        bool GetSTOAAddressesSync(ICatalogueEntry& requestEntry, TMessagesCollector& errors) const;

    private:
        bool SendSyncPostRequest(EReninsClaimOperationType operationType, const TString& apiPath, IRequestEntry& requestEntry, TMessagesCollector& errors) const;
        NThreading::TFuture<void> SendAsyncPostRequest(EReninsClaimOperationType operationType, const TString& apiPath, IRequestEntry& requestEntry) const;
        NThreading::TFuture<NJson::TJsonValue> SendRequest(EReninsClaimOperationType operationType, const NNeh::THttpRequest& request) const;

    private:
        THolder<TSimpleHttpClient> SimpleHttpClient;
    };
}
