#pragma once

#include "config.h"
#include "entity_base.h"
#include "scheme_adapters.h"

#include <drive/library/cpp/scheme/scheme.h>

#include <library/cpp/threading/future/future.h>

#include <rtline/util/types/accessor.h>

class IServerBase;

namespace NNeh {
    class THttpClient;
}

namespace NDrive::NRenins {
    class TDocument: public IRequestInfoEntry {
    public:
        TDocument() = default;
        TDocument(const TString& url, const TString& attachmentCode, const TString& name);

        static NDrive::TScheme GetScheme(const IServerBase& server, const IVariantsAdapter& variantsAdapter);

        NThreading::TFuture<NJson::TJsonValue> MakeRequestDataAsync(const TReninsClaimClientConfig& config, NNeh::THttpClient& client) const;

        virtual NJson::TJsonValue MakeRequestData(const TReninsClaimClientConfig& config) const override;
        virtual bool ParseResponse(const NJson::TJsonValue& data) override;

        virtual NJson::TJsonValue SerializeToJson() const override;
        virtual bool DeserializeFromJson(const NJson::TJsonValue& data) override;

    private:
        R_FIELD(TString, Data);
        R_FIELD(TString, Url);
        R_FIELD(TString, AttachmentCode);
        R_FIELD(TString, Name);
    };

    class TDocuments: public IRequestInfoEntry {
    public:
        static NDrive::TScheme GetScheme(const IServerBase& server, const IVariantsAdapter& variantsAdapter, const TMaybe<TDocuments>& entry = {});

        virtual NJson::TJsonValue MakeRequestData(const TReninsClaimClientConfig& config) const override;
        virtual bool ParseResponse(const NJson::TJsonValue& data) override;

        virtual NJson::TJsonValue SerializeToJson() const override;
        virtual bool DeserializeFromJson(const NJson::TJsonValue& data) override;

    private:
        R_FIELD(TVector<TDocument>, Documents);
    };

    class TDocumentsEntry: public IRequestEntry {
    public:
        static NDrive::TScheme GetScheme(const IServerBase& server, const IVariantsAdapter& variantsAdapter);

        virtual NJson::TJsonValue MakeRequestData(const TReninsClaimClientConfig& config) const override;
        virtual bool ParseResponse(const NJson::TJsonValue& data) override;

        virtual NJson::TJsonValue SerializeToJson() const override;
        virtual bool DeserializeFromJson(const NJson::TJsonValue& data) override;

        virtual bool Validate(TMessagesCollector& errors) const override;

    private:
        R_FIELD(TString, ClaimNumber);
        R_FIELD(TDocuments, Documents);
    };
}
