#include "config.h"

#include <util/stream/file.h>
#include <util/string/cast.h>

namespace NDrive::NRenins {
    TReninsClaimClientConfig TReninsClaimClientConfig::ParseFromString(const TString& configStr) {
        return TBase::ParseFromString<TReninsClaimClientConfig>(configStr);
    }

    void TReninsClaimClientConfig::Init(const TYandexConfig::Section* section, const TMap<TString, NSimpleMeta::TConfig>* requestPolicy) {
        TBase::Init(section, requestPolicy);

        const auto& directives = section->GetDirectives();
        Login = directives.Value<TString>("Login", Login);
        Password = directives.Value<TString>("Password", Password);
        PasswordPath = directives.Value<TString>("PasswordPath", PasswordPath);
        if (!Password && PasswordPath) {
            Password = Strip(TFileInput(PasswordPath).ReadAll());
        }

        CreateKaskoApiPath = directives.Value<TString>("CreateKaskoApiPath", CreateKaskoApiPath);
        CreateOsagoApiPath = directives.Value<TString>("CreateOsagoApiPath", CreateOsagoApiPath);
        UploadDocumentsApiPath = directives.Value<TString>("UploadDocumentsApiPath", UploadDocumentsApiPath);
        CatalogueApiPath = directives.Value<TString>("CatalogueApiPath", CatalogueApiPath);
        STOAListApiPath = directives.Value<TString>("STOAListApiPath", STOAListApiPath);

        AttachmentDownloadTimeout = directives.Value<TDuration>("AttachmentDownloadTimeout", AttachmentDownloadTimeout);
        UseSimpleHttpClient = directives.Value("UseSimpleHttpClient", UseSimpleHttpClient);
    }

    void TReninsClaimClientConfig::ToString(IOutputStream& os) const {
        TBase::ToString(os);
        os << "Login: " << Login << Endl;
        os << "PasswordPath: " << PasswordPath << Endl;
        os << "CreateKaskoApiPath: " << CreateKaskoApiPath << Endl;
        os << "CreateOsagoApiPath: " << CreateOsagoApiPath << Endl;
        os << "UploadDocumentsApiPath: " << UploadDocumentsApiPath << Endl;
        os << "CatalogueApiPath: " << CatalogueApiPath << Endl;
        os << "STOAListApiPath: " << STOAListApiPath << Endl;
        os << "AttachmentDownloadTimeout: " << AttachmentDownloadTimeout << Endl;
        os << "UseSimpleHttpClient: " << UseSimpleHttpClient << Endl;
    }
}
