#pragma once

#include <rtline/library/deprecated/async_impl/config.h>

namespace NDrive::NRenins {
    class TReninsClaimClientConfig: public TRequestConfig {
    private:
        using TBase = TRequestConfig;

    public:
        using TBase::TBase;

        static TReninsClaimClientConfig ParseFromString(const TString& configStr);

        void Init(const TYandexConfig::Section* section, const TMap<TString, NSimpleMeta::TConfig>* requestPolicy);
        void ToString(IOutputStream& os) const;

    private:
        R_FIELD(TString, Login);
        R_FIELD(TString, Password);
        R_FIELD(TString, PasswordPath);

        R_FIELD(TString, CreateKaskoApiPath, "jsonAPI/rest/createKASKO");
        R_FIELD(TString, CreateOsagoApiPath, "jsonAPI/rest/createOSAGO");
        R_FIELD(TString, UploadDocumentsApiPath, "jsonAPI/rest/uploadDocs");
        R_FIELD(TString, CatalogueApiPath, "jsonAPI/rest/getCatalog");
        R_FIELD(TString, STOAListApiPath, "jsonAPI/rest/getSTOAList");

        R_FIELD(TDuration, AttachmentDownloadTimeout, TDuration::Seconds(30));
        R_FIELD(bool, UseSimpleHttpClient, true);
    };
}
