#pragma once

#include <util/generic/string.h>

namespace NDrive::NRenins {
    enum class EClaimType {
        Kasko /* "КАСКО" */,
        Osago /* "ОСАГО" */,
    };

    static const TString OsagoSettingPrefix = "incident.osago";
    static const TString KaskoSettingPrefix = "incident.kasko";

    enum class EOsagoCatalogueType {
        DamageClassification /* "REN_INS_CLASS_AVTO" */,  // Вид убытка
        DamageType /* "REN_CLAIM_DAMAGE_TYPE" */,  // Тип ущерба
        PropertyType /* "REN_PROPERTY_TYPE" */,  // Тип имущества
        LossCode /* "REN_CLAIM_EVENT_LOSS_CODE" */,  // Что случилось [compound objects]
        RegulationType /* "REN_CLAIM_REGULATION_TYPE" */,  // Форма возмещения
        RegistrationChannel /* "REN_CLAIM_REG_CHANNEL_OSAGO" */,  // Канал регистрации
        RegistrationType /* "REN_REGISTRATION" */,  // Регистрация инцидента
        ViolatedPDDRule /* "REN_PDD_RULES" */,  // Нарушенный пункт ПДД
        AccidentScheme /* "REN_ACCIDENT_SCHEME" */,  // Номер схемы ДТП [mapping value-description]
        AccidentSchemePosition /* "REN_SCHEME_POSITION" */,  // Позиция на схеме
        ReportingMethod /* "REN_CLAIM_INCOMING_METHOD" */,  // Способ поступления
        RFSubject /* "REN_RF_SUBJECT" */,  // Субъект РФ (область)
        Territory /* "REN_OSAGO_TERRITORY" */,  // Город
        LocationType /* "INS_CLAIMS_LD_LOCATION_TYPE" */,  // Тип места происшествия
        Country /* "COUNTRY" */,  // Страна
        VehicleRole /* "REN_VEHICLE_ROLE" */,  // Роль ТС
        VehicleType /* "REN_RSA_VEHICLE_TYPE" */,  // Тип ТС
        VehicleModel /* "CX_REN_VEH_MDL" */,  // Марка и модель ТС [compound objects]
        VehicleColor /* "REN_SELECT_VEHICLE_COLOR" */,  // Цвет кузова ТС
        VehicleDocumentType /* "REN_VEHICLES_DOCS" */,  // Вид документа ТС [mapping value-description]
        DamageList /* "REN_DAMAGE_LIST" */,  // Элементы ТС
        Role /* "REN_CLAIM_ACC_ROLE_OSAGO" */,  // Сторона
        PersonDocumentType /* "CONTACT_DOCUMENT_TYPE" */,  // Вид документа (физ.)
        FinCoprClientLegalForm /* "FINCORP_CLIENT_LEGAL_FORM" */,  // Организационно-правовая форма [mapping value-description]

        STOAAddress /* "REN_STOA_ADDRESS" */,  // Адреса сервисов, используется отдельный метод [compound objects]

        DocumentType /* "REN_ALF_CLAIM_NAME" */, // Шаблоны документов, не меняются, невозможно запросить [mapping value-description]
    };

    enum class EKaskoCatalogueType {
        LossCode /* "INS_CLAIM_EVENT_LOSS_CODE" */,  // Что случилось, не меняются, невозможно запросить  [compound objects]
        RegistrationType /* "REN_REGISTRATION" */,  // Регистрация инцидента
        Guilty /* "INS_CLAIM_AT_FAULT" */,  // Виновник ДТП
        Role /* "FINS_CLM_IN_ACC_EDU_MLOV" */,  // Роль физ. лица
        LocationType /* "INS_CLAIMS_LD_LOCATION_TYPE" */,  // Тип места происшествия
        Site /* "REN_SITE_VALUE" */,  // Филиалы
        DamageList /* "REN_DAMAGE_LIST" */,  // Элементы ТС
        Territory /* "REN_OSAGO_TERRITORY" */,  // Город
        PartnerRole /* "REN_PERS_ACC_ROLE" */,  // Роль партнера
        CompensationType /* "REN_COMPENSATION_TYPE" */,  // Форма возмещения
        VehicleColor /* "REN_SELECT_VEHICLE_COLOR" */,  // Цвет кузова ТС
        DocumentType /* "REN_ALF_CLAIM_NAME" */,  // Шаблоны документов [mapping value-description]

        STOAAddress /* "REN_STOA_ADDRESS" */,  // Адреса сервисов, используется отдельный метод [compound objects]
    };

    static const TString DefaultTimezoneName = "Europe/Moscow";
    static const TString DefaultDateFormat = "%d.%m.%Y";
    static const TString DefaultDateTimeFormat = "%d.%m.%Y %H:%M:%S";
}
