#pragma once

#include "config.h"

#include <library/cpp/json/json_value.h>

#include <rtline/util/types/messages_collector.h>

namespace NDrive::NRenins {
    // interface of an intermediate entry, part of a requestable one
    class IRequestInfoEntry {
    public:
        virtual ~IRequestInfoEntry() = default;

        // external data interaction
        virtual NJson::TJsonValue MakeRequestData(const TReninsClaimClientConfig& config) const = 0;
        virtual bool ParseResponse(const NJson::TJsonValue& data) = 0;

        // internal data interaction (admin interface, incident contexts, global settings)
        virtual NJson::TJsonValue SerializeToJson() const = 0;
        virtual bool DeserializeFromJson(const NJson::TJsonValue& data) = 0;
    };

    // interface of a requestable entry
    class IRequestEntry: public IRequestInfoEntry {
    public:
        virtual bool Validate(TMessagesCollector& errors) const = 0;
    };
}
