#include "json_adapters.h"

#include <drive/library/cpp/raw_text/phone_number.h>

namespace NJson {
    namespace NPrivate {
        TJsonValue ReninsPhoneNumberToJson(const TString& value) {
            TString strippedPhoneNumber = StripStringLeft(value, EqualsStripAdapter('+'));
            return ToJson(strippedPhoneNumber);
        }

        TJsonValue ReninsBooleanToJson(bool value) {
            return ToJson((value) ? TStringBuf{"Y"} : TStringBuf{"N"});
        }

        TJsonValue ReninsDateTimeToJson(TInstant value) {
            TInstant localTimestamp = NUtil::ConvertTimeZone(value, NUtil::GetUTCTimeZone(), NUtil::GetTimeZone(NDrive::NRenins::DefaultTimezoneName));
            return ToJson(NUtil::FormatDatetime(localTimestamp, NDrive::NRenins::DefaultDateTimeFormat));
        }

        bool TryReninsPhoneNumberFromJson(const TJsonValue& value, TString& result) {
            if (!value.IsString()) {
                return false;
            }
            TPhoneNormalizer phoneNormalizer;
            result = phoneNormalizer.TryNormalize(value.GetString());
            return true;
        }

        bool TryReninsBooleanFromJson(const TJsonValue& value, bool& result) {
            if (!value.IsString()) {
                return false;
            }
            if (value.GetString() == "Y") {
                result = true;
            } else if (value.GetString() == "N") {
                result = false;
            } else {
                return false;
            }
            return true;
        }

        bool TryReninsDateTimeFromJson(const TJsonValue& value, TInstant& result) {
            if (!value.IsString()) {
                return false;
            }
            result = NUtil::ParseFomattedLocalDatetime(value.GetString(), NDrive::NRenins::DefaultDateTimeFormat, NDrive::NRenins::DefaultTimezoneName);
            return true;
        }
    }
}
