#pragma once

#include "catalogue_entity_base.h"

#include <drive/backend/abstract/base.h>

#include <drive/library/cpp/scheme/scheme.h>

#include <util/string/cast.h>

namespace NDrive {
    class IVariantsAdapter {
    public:
        using TCompoundVariants = TFSVariants::TCompoundVariants;

        virtual operator TCompoundVariants() const = 0;
    };

    template <typename T, typename = std::is_base_of<NDrive::NRenins::ICatalogueEntry, T>>
    class TReninsCatalogueEntryAdapter: public IVariantsAdapter {
    public:
        static TCompoundVariants Cast() {
            return static_cast<TCompoundVariants>(TReninsCatalogueEntryAdapter<T>());
        }

        virtual operator TCompoundVariants() const override {
            T entry;
            if (!NDrive::HasServer() || !entry.LoadSettingValue(&NDrive::GetServer())) {
                return {};
            }
            return static_cast<TCompoundVariants>(entry);
        }
    };
}

using IVariantsAdapter = NDrive::IVariantsAdapter;

template <typename T>
using TReninsCatalogueEntryAdapter = NDrive::TReninsCatalogueEntryAdapter<T>;
