#include <drive/backend/incident/renins_claims/client.h>

#include <library/cpp/logger/global/global.h>
#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/tests_data.h>

#include <rtline/library/json/parse.h>
#include <rtline/util/types/messages_collector.h>

#include <util/string/join.h>

namespace {
    auto GetClient() {
        const TString configStr = R"(
            Host: test-integr.renins.com
            Port: 443
            IsHttps: true
            RequestTimeout: 30s
            Login: klient@test.ru
            Password: 123456
        )";

        auto config = NDrive::NRenins::TReninsClaimClientConfig::ParseFromString(configStr);
        return NDrive::NRenins::TReninsClaimClient(config);
    }
}

Y_UNIT_TEST_SUITE(ReninsClaim) {
    Y_UNIT_TEST(SeriesCatalogueValue) {
        auto client = GetClient();
        NDrive::NRenins::TKaskoRegistrationTypeEntry entry;
        TMessagesCollector errors;
        UNIT_ASSERT_C(client.GetCatalogueValuesSync(entry, errors), errors.GetStringReport());
    }

    Y_UNIT_TEST(MappedCatalogueValue) {
        auto client = GetClient();
        NDrive::NRenins::TKaskoDocumentTypeEntry entry;
        TMessagesCollector errors;
        UNIT_ASSERT_C(client.GetCatalogueValuesSync(entry, errors), errors.GetStringReport());
    }

    Y_UNIT_TEST(TerritoryCatalogueValue) {
        auto client = GetClient();
        NDrive::NRenins::TKaskoTerritoryEntry entry;
        TMessagesCollector errors;
        UNIT_ASSERT_C(client.GetCatalogueValuesSync(entry, errors), errors.GetStringReport());
    }

    Y_UNIT_TEST(STOAList) {
        auto client = GetClient();
        NDrive::NRenins::TKaskoSTOAAddressEntry entry;
        TMessagesCollector errors;
        UNIT_ASSERT_C(client.GetSTOAAddressesSync(entry, errors), errors.GetStringReport());
        for (auto&& [id, info] : entry.GetAddresses()) {
            Cout << id << Endl;
        }
    }

    Y_UNIT_TEST(STOAListStatic) {
        auto responseString = R"(
{
    "Error_spcCode": "",
    "Error_spcMessage": "",
    "RENGetStoaList": {
        "PersonalAccount": {
            "Id": null,
            "ListOfSTOA": {
                "STOA": [
                    {
                        "Id": "1-6JIZVR8",
                        "Address": "107076, г. Москва, ул. Краснобогатырская, д. 89",
                        "KLADR": "7700000000015780036",
                        "OKATO": "45263594000",
                        "Name": "PD"
                    },
                    {
                        "Id": "1-4WAU5P9",
                        "Address": "354003, Краснодарский край, г. Сочи, ул. Пластунская (Район Центральный), д. 102А",
                        "KLADR": "23000007000156500",
                        "OKATO": "03426000000",
                        "Name": "PD2"
                    }
                ]
            }
        }
    }
}
        )";
        auto response = NJson::ReadJsonFastTree(responseString);
        NDrive::NRenins::TKaskoSTOAAddressEntry entry;
        UNIT_ASSERT(entry.ParseResponse(response));
        UNIT_ASSERT_VALUES_EQUAL(entry.GetAddresses().size(), 2);
    }
}
