#include "close.h"

namespace NDrive {
    TCloseIncidentTransition::TRegistrator TCloseIncidentTransition::Registrator;

    TSet<EIncidentStatus> TCloseIncidentTransition::GetAllowedSourceStatuses() const {
        return { EIncidentStatus::New, EIncidentStatus::StartrekTicketsProcessed, EIncidentStatus::ObjectTagsProcessed, EIncidentStatus::KaskoClaimApplied };
    }

    EIncidentStatus TCloseIncidentTransition::GetDestinationStatus(const TIncidentStateContext& /* context */) const {
        return EIncidentStatus::Closed;
    }
}
