#pragma once

#include <drive/backend/incident/constants.h>
#include <drive/backend/incident/states.h>

#include <util/string/cast.h>

namespace NDrive {
    class TCloseIncidentTransition: public IBaseIncidentTransition {
        FACTORY_INCIDENT_TRANSITION(TCloseIncidentTransition, EIncidentTransition::Close);

    public:
        virtual TSet<EIncidentStatus> GetAllowedSourceStatuses() const override;
        virtual EIncidentStatus GetDestinationStatus(const TIncidentStateContext& context) const override;
    };
}
