#include "discard.h"

#include <util/generic/algorithm.h>
#include <util/generic/set.h>

namespace NDrive {
    TDiscardIncidentTransition::TRegistrator TDiscardIncidentTransition::Registrator;

    TSet<EIncidentStatus> TDiscardIncidentTransition::GetAllowedSourceStatuses() const {
        auto allEnumValues = GetEnumAllValues<EIncidentStatus>();

        TSet<EIncidentStatus> statuses(allEnumValues.begin(), allEnumValues.end());
        ForEach(Y_ARRAY_BEGIN(TerminalStatuses), Y_ARRAY_END(TerminalStatuses), [&statuses](auto&& status){ statuses.erase(status); });

        return statuses;
    }

    EIncidentStatus TDiscardIncidentTransition::GetDestinationStatus(const TIncidentStateContext& /* context */) const {
        return EIncidentStatus::Discarded;
    }
}
