#pragma once

#include <drive/backend/incident/constants.h>
#include <drive/backend/incident/states.h>

#include <util/string/cast.h>

namespace NDrive {
    class TDiscardIncidentTransition: public IBaseIncidentTransition {
        FACTORY_INCIDENT_TRANSITION(TDiscardIncidentTransition, EIncidentTransition::Discard);

    public:
        virtual TSet<EIncidentStatus> GetAllowedSourceStatuses() const override;
        virtual EIncidentStatus GetDestinationStatus(const TIncidentStateContext& context) const override;
    };
}
