#pragma once

#include <drive/backend/incident/constants.h>
#include <drive/backend/incident/states.h>

#include <util/string/cast.h>

template <class TObject>
class TObjectEvent;

class TConstDBTag;

namespace NDrive {
    class TFetchRelatedDocumentsIncidentTransition: public IBaseIncidentTransition {
        using TImageId = TIncidentPhotoLink::TImageId;
        using TImageIds = TSet<TImageId>;

        using TAttachmentCodeMapping = TMap<TString, TString>;

        FACTORY_INCIDENT_TRANSITION(TFetchRelatedDocumentsIncidentTransition, EIncidentTransition::FetchRelatedDocuments);

    public:
        virtual bool Initialize(const NJson::TJsonValue& data, const TIncidentStateContext& context, TMessagesCollector& errors) override;

        virtual TSet<EIncidentStatus> GetAllowedSourceStatuses() const override;
        virtual EIncidentStatus GetDestinationStatus(const TIncidentStateContext& context) const override;

    private:
        virtual TMaybe<bool> DoCheckIsApplicable(const TIncidentStateContext& context, NDrive::TEntitySession& session) const override;
        virtual bool DoPerform(TIncidentStateContext& context, NDrive::TEntitySession& session) const override;

        bool GetRelatedImageIds(const TIncidentStateContext& context, TImageIds& imageIds, NDrive::TEntitySession& session) const;
        TSet<TString> GetEventRelatedIssues(const TObjectEvent<TConstDBTag>& event) const;

    private:
        R_READONLY(TSet<TString>, RelatedDocumentTagIds);
        R_READONLY(TSet<TString>, RelatedDocumentTagNames);

        R_READONLY(TString, DefaultAttachmentCode);
        R_READONLY(TAttachmentCodeMapping, AttachmentCodeMapping);
    };
}
