#pragma once

#include <drive/backend/incident/constants.h>
#include <drive/backend/incident/states.h>

#include <util/string/cast.h>

class TCarInsurancePolicy;

namespace NDrive::NRenins {
    class TKaskoGeneralClaimInfo;
    class TKaskoPolicy;
    class TKaskoClaim;
    class TKaskoDeclarant;
    class TKaskoParticipant;
    class TKaskoVehicle;
}

namespace NDrive {
    class TReninsKaskoClaimIncidentContext;

    class TFetchReninsKaskoDefaultsIncidentTransition: public IBaseIncidentTransition {
        FACTORY_INCIDENT_TRANSITION(TFetchReninsKaskoDefaultsIncidentTransition, EIncidentTransition::FetchReninsKaskoDefaults);

    public:
        virtual bool Initialize(const NJson::TJsonValue& data, const TIncidentStateContext& context, TMessagesCollector& errors) override;

        virtual TSet<EIncidentStatus> GetAllowedSourceStatuses() const override;
        virtual EIncidentStatus GetDestinationStatus(const TIncidentStateContext& context) const override;

    private:
        virtual TMaybe<bool> DoCheckIsApplicable(const TIncidentStateContext& context, NDrive::TEntitySession& session) const override;
        virtual bool DoPerform(TIncidentStateContext& context, NDrive::TEntitySession& session) const override;

        bool FillGeneralClaimInfo(const TIncidentStateContext& context, NDrive::NRenins::TKaskoGeneralClaimInfo& generalClaimInfo, NDrive::TEntitySession& session) const;
        bool FillPolicy(const TIncidentStateContext& context, TCarInsurancePolicy& insurancePolicy, NDrive::TInfoEntitySession& session) const;
        bool FillClaim(const TIncidentStateContext& context, const TCarInsurancePolicy& insurancePolicy, NDrive::NRenins::TKaskoClaim& claim, NDrive::TEntitySession& session) const;
        bool FillDeclarant(const TIncidentStateContext& context, NDrive::NRenins::TKaskoDeclarant& declarant, NDrive::TEntitySession& session) const;
        bool FillParticipants(const TIncidentStateContext& context, const NDrive::NRenins::TKaskoPolicy& driverPolicy, TVector<NDrive::NRenins::TKaskoParticipant>& participants, NDrive::TEntitySession& session) const;
        bool FillVehicleDescription(const TIncidentStateContext& context, NDrive::NRenins::TKaskoVehicle& vehicleDescription, NDrive::NRenins::TKaskoPolicy& driverPolicy, NDrive::TEntitySession& session) const;

    private:
        R_READONLY(TAtomicSharedPtr<TReninsKaskoClaimIncidentContext>, ContextPtr);
    };
}
