#include "fill_renins_kasko_claim.h"

#include <drive/backend/incident/contexts/renins_kasko_claim.h>

#include <drive/backend/abstract/frontend.h>
#include <drive/backend/incident/renins_claims/claim_entity_kasko.h>

namespace NDrive {
    TFillReninsKaskoClaimIncidentTransition::TRegistrator TFillReninsKaskoClaimIncidentTransition::Registrator;

    TFillReninsKaskoClaimIncidentTransition::TFillReninsKaskoClaimIncidentTransition()
        : ContextPtr(MakeAtomicShared<TReninsKaskoClaimIncidentContext>())
    {
    }

    NDrive::TScheme TFillReninsKaskoClaimIncidentTransition::GetScheme(const TIncidentStateContext& context) const {
        TMaybe<EIncidentType> incidentType;
        IIncidentContext::TPtr existingContextPtr;
        if (context.HasInstance()) {
            incidentType = context.GetInstanceRef().GetIncidentType();
            existingContextPtr = context.GetInstanceRef().GetContext(TReninsKaskoClaimIncidentContext::GetTypeName());
        }
        return TReninsKaskoClaimIncidentContext::GetScheme(*context.GetServer(), incidentType, existingContextPtr);
    }

    bool TFillReninsKaskoClaimIncidentTransition::Initialize(const NJson::TJsonValue& data, const TIncidentStateContext& /* context */, TMessagesCollector& errors) {
        return ContextPtr->DeserializeFromJson(data, errors);
    }

    TSet<EIncidentStatus> TFillReninsKaskoClaimIncidentTransition::GetAllowedSourceStatuses() const {
        return { EIncidentStatus::ObjectTagsProcessed, EIncidentStatus::KaskoClaimApplied };
    }

    EIncidentStatus TFillReninsKaskoClaimIncidentTransition::GetDestinationStatus(const TIncidentStateContext& context) const {
        auto currentStatus = context.GetCurrentStatus();

        // suppose claim to be applied if claim number is set
        if (currentStatus == EIncidentStatus::ObjectTagsProcessed && context.HasInstance()) {
            auto claimContextPtr = context.GetInstanceRef().GetContext<TReninsKaskoClaimIncidentContext>();
            if (claimContextPtr && !claimContextPtr->GetClaimEntryPtr()->IsInitialClaimApplication()) {
                return EIncidentStatus::KaskoClaimApplied;
            }
        }

        return currentStatus;
    }

    TMaybe<bool> TFillReninsKaskoClaimIncidentTransition::DoCheckIsApplicable(const TIncidentStateContext& context, NDrive::TEntitySession& /* session */) const {
        return (context.HasInstance()) ? (context.OptionalInstance()->GetIncidentType() != EIncidentType::Evacuation) : false;
    }

    bool TFillReninsKaskoClaimIncidentTransition::DoPerform(TIncidentStateContext& context, NDrive::TEntitySession& /* session */) const {
        context.MutableInstance()->UpsertContext(ContextPtr);
        return true;
    }
}
