#pragma once

#include <drive/backend/incident/constants.h>
#include <drive/backend/incident/states.h>

#include <drive/backend/incident/renins_claims/scheme_adapters.h>

#include <util/string/cast.h>

namespace NDrive {
    class THandleAttachedPhotosIncidentTransition: public IBaseIncidentTransition {
        FACTORY_INCIDENT_TRANSITION(THandleAttachedPhotosIncidentTransition, EIncidentTransition::HandleAttachedPhotos);

    public:
        class TAction {
        public:
            static NDrive::TScheme GetScheme(const NDrive::IServer& server, const IVariantsAdapter& variantsAdapter);

        private:
            R_FIELD(EAttachedPhotosHandlingAction, ActionType);

            R_FIELD(TIncidentPhotoLink::TImageId, ImageId, Default<TIncidentPhotoLink::TImageId>());
            R_FIELD(TString, AttachmentCode);
            R_FIELD(TString, Comment);
        };

    public:
        virtual NDrive::TScheme GetScheme(const TIncidentStateContext& context) const override;
        virtual bool Initialize(const NJson::TJsonValue& data, const TIncidentStateContext& context, TMessagesCollector& errors) override;

        virtual TSet<EIncidentStatus> GetAllowedSourceStatuses() const override;
        virtual EIncidentStatus GetDestinationStatus(const TIncidentStateContext& context) const override;

    private:
        bool ValidateImageActions(const TIncidentStateContext& context, TMessagesCollector& errors) const;

        virtual TMaybe<bool> DoCheckIsApplicable(const TIncidentStateContext& context, NDrive::TEntitySession& session) const override;
        virtual bool DoPerform(TIncidentStateContext& context, NDrive::TEntitySession& session) const override;

        bool UpsertPhotoLink(const TAction& action, TIncidentStateContext& context, NDrive::TEntitySession& session) const;
        bool RemovePhotoLink(const TAction& action, TIncidentStateContext& context, NDrive::TEntitySession& session) const;

    private:
        TVector<TAction> Actions;
        mutable TMap<TIncidentPhotoLink::TImageId, TString> ImageUrlMapping;
    };
}
