#pragma once

#include "handle_object_tags_base.h"

#include <drive/backend/car_attachments/documents/insurance.h>


namespace NDrive {
    class IHandleAvarcomTagsTransition: public THandleObjectTagsBaseTransition {
    private:
        using TBase = THandleObjectTagsBaseTransition;

    private:
        R_FIELD(TSet<TString>, AvarcomUserIds);

    public:
        virtual TSet<EIncidentStatus> GetAllowedSourceStatuses() const override;
        virtual bool Initialize(const NJson::TJsonValue& data, const TIncidentStateContext& context, TMessagesCollector& errors) override;

    private:
        virtual NDrive::EInsuranceProvider GetInsuranceProvider() const = 0;
        virtual TString GetSettingPrefix() const override;
        virtual EIncidentContextType GetContextType() const override;

        virtual TMaybe<bool> DoCheckIsApplicable(const TIncidentStateContext& context, NDrive::TEntitySession& session) const override;
        virtual bool DoPerformTags(TIncidentStateContext& context, const TJsonFetchContext& fetchContext, NDrive::TEntitySession& session) const override;
    };

    class THandleAvarcomReninsTagsTransition: public IHandleAvarcomTagsTransition {
    private:
        FACTORY_INCIDENT_TRANSITION(THandleAvarcomReninsTagsTransition, EIncidentTransition::HandleAvarcomReninsTags);

    private:
        virtual NDrive::EInsuranceProvider GetInsuranceProvider() const override;
    };

    class THandleAvarcomIngosTagsTransition: public IHandleAvarcomTagsTransition {
    private:
        FACTORY_INCIDENT_TRANSITION(THandleAvarcomIngosTagsTransition, EIncidentTransition::HandleAvarcomIngosTags);

    private:
        virtual NDrive::EInsuranceProvider GetInsuranceProvider() const override;
    };
}
