#include "handle_evacuation_object_tags.h"

namespace NDrive {
    THandleEvacuationObjectTagsTransition::TRegistrator THandleEvacuationObjectTagsTransition::Registrator;

    TString THandleEvacuationObjectTagsTransition::GetSettingPrefix() const {
        return EvacuationSettingPrefix;
    }

    EIncidentContextType THandleEvacuationObjectTagsTransition::GetContextType() const {
        return EIncidentContextType::EvacuationTicket;
    }

    TMaybe<bool> THandleEvacuationObjectTagsTransition::DoCheckIsApplicable(const TIncidentStateContext& context, NDrive::TEntitySession& /* session */) const {
        return (context.HasInstance()) ? (context.OptionalInstance()->GetIncidentType() == EIncidentType::Evacuation) : false;
    }
}
