#include "handle_incident_object_tags.h"

namespace NDrive {
    THandleIncidentObjectTagsTransition::TRegistrator THandleIncidentObjectTagsTransition::Registrator;

    TString THandleIncidentObjectTagsTransition::GetSettingPrefix() const {
        return GenericIncidentSettingPrefix;
    }

    EIncidentContextType THandleIncidentObjectTagsTransition::GetContextType() const {
        return EIncidentContextType::IncidentTicket;
    }

    TMaybe<bool> THandleIncidentObjectTagsTransition::DoCheckIsApplicable(const TIncidentStateContext& context, NDrive::TEntitySession& /* session */) const {
        return (context.HasInstance()) ? (context.OptionalInstance()->GetIncidentType() != EIncidentType::Evacuation) : false;
    }
}
