#pragma once

#include <drive/backend/incident/constants.h>
#include <drive/backend/incident/states.h>

#include <drive/backend/context_fetcher/json.h>

#include <rtline/util/types/messages_collector.h>

#include <util/string/cast.h>

class IEntityTagsManager;

namespace NDrive {
    class IServer;
}

namespace NDrive {
    class THandleObjectTagsBaseTransition: public IBaseIncidentTransition {
    public:
        virtual TSet<EIncidentStatus> GetAllowedSourceStatuses() const override;
        virtual EIncidentStatus GetDestinationStatus(const TIncidentStateContext& context) const override;

    private:
        virtual TString GetSettingPrefix() const = 0;
        virtual EIncidentContextType GetContextType() const = 0;

    protected:
        virtual bool DoPerformTags(TIncidentStateContext& context, const TJsonFetchContext& fetchContext, NDrive::TEntitySession& session) const;

        TMaybe<TJsonFetchContext> PrepareFetchContext(TIncidentStateContext& context, NDrive::TEntitySession& session) const;

        TMaybe<TVector<NJson::TJsonValue>> ParseTags(const NDrive::IServer* server, const TJsonFetchContext& context, const TString& settingKey, TMessagesCollector& errors) const;
        TMaybe<TMap<TString, NJson::TJsonValue>> ParseTagEvolutions(const NDrive::IServer* server, const TJsonFetchContext& context, const TString& settingKey, TMessagesCollector& errors) const;
        TMaybe<NJson::TJsonValue> ParseTagData(const TString& rawTagData, const TJsonFetchContext& context, TMessagesCollector& errors) const;

        TString GetRobotUserId(const TIncidentStateContext& context) const;
        TString GetTagObjectId(const IEntityTagsManager& tagsManagerImpl, const TIncidentStateContext& context) const;

        bool AddTags(const IEntityTagsManager& tagsManagerImpl, const TVector<NJson::TJsonValue>& tagsData, TIncidentStateContext& context, TSet<TString>& processedTagIds, NDrive::TEntitySession& session, const TString& entityId = "") const;
        bool EvolveTags(const IEntityTagsManager& tagsManagerImpl, const TMap<TString, NJson::TJsonValue>& tagsDataMapping, TIncidentStateContext& context, TSet<TString>& processedTagIds, NDrive::TEntitySession& session) const;
        bool RemoveExtraTags(const IEntityTagsManager& tagsManagerImpl, const TSet<TString>& processedTagIds, TIncidentStateContext& context, NDrive::TEntitySession& session) const;

    private:
        virtual bool DoPerform(TIncidentStateContext& context, NDrive::TEntitySession& session) const override;
    };
}
