#include "make_evacuation_ticket.h"

#include <drive/backend/incident/incident_context.h>
#include <drive/backend/incident/contexts/evacuation_ticket.h>

#include <drive/backend/abstract/frontend.h>
#include <drive/backend/database/transaction/tx.h>

#include <rtline/util/algorithm/ptr.h>

namespace NDrive {
    TMakeEvacuationTicketTransition::TRegistrator TMakeEvacuationTicketTransition::Registrator;

    TMakeEvacuationTicketTransition::TMakeEvacuationTicketTransition()
        : TBase(MakeAtomicShared<TEvacuationTicketIncidentContext>(), MakeAtomicShared<TNotifyHandlers>("incident_transition-" + GetTypeName()))
    {
    }

    NDrive::TScheme TMakeEvacuationTicketTransition::GetScheme(const TIncidentStateContext& context) const {
        TMaybe<EIncidentType> incidentType;
        IIncidentContext::TPtr existingContextPtr;
        if (context.HasInstance()) {
            incidentType = context.GetInstanceRef().GetIncidentType();
            existingContextPtr = context.GetInstanceRef().GetContext(TEvacuationTicketIncidentContext::GetTypeName());
        }
        return TEvacuationTicketIncidentContext::GetScheme(*context.GetServer(), incidentType, existingContextPtr);
    }

    bool TMakeEvacuationTicketTransition::Initialize(const NJson::TJsonValue& data, const TIncidentStateContext& context, TMessagesCollector& errors) {
        if (!TBase::Initialize(data, context, errors)) {
            return false;
        }

        auto nativeContextPtr = std::dynamic_pointer_cast<TEvacuationTicketIncidentContext>(GetDataContextPtr());
        if (!nativeContextPtr) {
            return false;
        }

        return true;
    }

    TString TMakeEvacuationTicketTransition::GetSettingKey(TStringBuf settingKeySuffix) const {
        return EvacuationSettingPrefix + "." + settingKeySuffix;
    }

    TMaybe<bool> TMakeEvacuationTicketTransition::DoCheckIsApplicable(const TIncidentStateContext& context, NDrive::TEntitySession& /* session */) const {
        return (context.HasInstance()) ? (context.OptionalInstance()->GetIncidentType() == EIncidentType::Evacuation) : false;
    }

    bool TMakeEvacuationTicketTransition::HandleIssueAttachments(const TIncidentStateContext& /* context */, NJson::TJsonValue& /* contextEntry */, NDrive::TEntitySession& /* session */) const {
        return true;  // context does not contain any startrek attachments to process
    }

    bool TMakeEvacuationTicketTransition::HandleComponents(const TIncidentStateContext& /* context */, TJsonFetchContext::TDynamicContext& /* dynamicContext */, NDrive::TEntitySession& /* session */) const {
        return true;
    }

    void TMakeEvacuationTicketTransition::InitializeLocalizedVariants(const TIncidentStateContext& context, TDynamicContext& dynamicContext, const ELocalization locale) const {
        TEvacuationTicketIncidentContext::InitializeLocalizedVariants(*context.GetServer(), dynamicContext, locale);
    }
}
