#pragma once

#include "make_ticket_base.h"

namespace NDrive {
    class TMakeIncidentTicketTransition: public TMakeTicketBaseTransition {
        using TBase = TMakeTicketBaseTransition;

        FACTORY_INCIDENT_TRANSITION(TMakeIncidentTicketTransition, EIncidentTransition::MakeIncidentTicket);

    public:
        TMakeIncidentTicketTransition();

        virtual NDrive::TScheme GetScheme(const TIncidentStateContext& context) const override;
        virtual bool Initialize(const NJson::TJsonValue& data, const TIncidentStateContext& context, TMessagesCollector& errors) override;

    private:
        virtual TMaybe<bool> DoCheckIsApplicable(const TIncidentStateContext& context, NDrive::TEntitySession& session) const override;

        virtual TString GetSettingKey(TStringBuf settingKeySuffix) const override;
        virtual bool HandleIssueAttachments(const TIncidentStateContext& context, NJson::TJsonValue& contextEntry, NDrive::TEntitySession& session) const override;
        virtual bool HandleComponents(const TIncidentStateContext& context, TJsonFetchContext::TDynamicContext& dynamicContext, NDrive::TEntitySession& session) const override;
        virtual void InitializeLocalizedVariants(const TIncidentStateContext& context, TDynamicContext& dynamicContext, const ELocalization locale = ELocalization::Rus) const override;
    };
}
