#pragma once

#include <drive/backend/incident/constants.h>
#include <drive/backend/incident/states.h>

#include <drive/backend/abstract/localization.h>
#include <drive/backend/context_fetcher/json.h>
#include <drive/backend/notifications/collection.h>

#include <library/cpp/json/json_value.h>

#include <rtline/util/types/messages_collector.h>

#include <util/string/cast.h>

namespace NDrive {
    class TNotifierResult;
}

namespace NDrive {
    class TMakeTicketBaseTransition: public IBaseIncidentTransition {
        using TBase = IBaseIncidentTransition;

    protected:
        using TDynamicContext = TMap<TString, TString>;
        using TNotifyHandlers = TContextNotifyHandlerCollection<EIncidentTransition, IJsonContextFetcher>;
        using TNotifierResultPtr = NDrive::TNotifierResult::TPtr;

    public:
        TMakeTicketBaseTransition(IIncidentContext::TPtr dataContextPtr, TNotifyHandlers::TPtr notifyHandlersPtr);

        virtual bool Initialize(const NJson::TJsonValue& data, const TIncidentStateContext& context, TMessagesCollector& errors) override;

        virtual TSet<EIncidentStatus> GetAllowedSourceStatuses() const override;
        virtual EIncidentStatus GetDestinationStatus(const TIncidentStateContext& context) const override;

    protected:
        TMaybe<NJson::TJsonValue> PrepareIssueAttachments(const NJson::TJsonValue& contextAttachments, const NJson::TJsonValue& existingAttachments, NDrive::TEntitySession& session) const;

    private:
        virtual bool DoPerform(TIncidentStateContext& context, NDrive::TEntitySession& session) const override;

        TMaybe<TJsonFetchContext> PrepareFetchContext(TIncidentStateContext& context, NDrive::TEntitySession& session) const;
        void InitializeExistingIssue(const TIncidentStateContext& context, TDynamicContext& dynamicContext) const;
        bool HandleNotifyResult(TNotifierResultPtr resultPtr, TIncidentStateContext& context, NDrive::TEntitySession& session) const;

    private:
        virtual TString GetSettingKey(TStringBuf settingKeySuffix) const = 0;
        virtual bool HandleIssueAttachments(const TIncidentStateContext& context, NJson::TJsonValue& contextEntry, NDrive::TEntitySession& session) const = 0;
        virtual bool HandleComponents(const TIncidentStateContext& context, TJsonFetchContext::TDynamicContext& dynamicContext, NDrive::TEntitySession& session) const = 0;
        virtual void InitializeLocalizedVariants(const TIncidentStateContext& context, TDynamicContext& dynamicContext, const ELocalization locale = ELocalization::Rus) const = 0;

    private:
        R_READONLY(IIncidentContext::TPtr, DataContextPtr);
        R_READONLY(TNotifyHandlers::TPtr, NotifyHandlersPtr);
    };
}
