#include "reopen.h"


#include <drive/backend/abstract/frontend.h>
#include <drive/backend/database/drive_api.h>
#include <drive/backend/incident/manager.h>

#include <util/generic/set.h>

namespace NDrive {
    TReopenIncidentTransition::TRegistrator TReopenIncidentTransition::Registrator;

    TSet<EIncidentStatus> TReopenIncidentTransition::GetAllowedSourceStatuses() const {
        return TSet<EIncidentStatus>(Y_ARRAY_BEGIN(TerminalStatuses), Y_ARRAY_END(TerminalStatuses));
    }

    EIncidentStatus TReopenIncidentTransition::GetDestinationStatus(const TIncidentStateContext& context) const {
        return DestinationStatus.GetOrElse(context.GetCurrentStatus());
    }

    bool TReopenIncidentTransition::DoPerform(TIncidentStateContext& context, NDrive::TEntitySession& session) const {
        const TString& incidentId = context.OptionalInstance()->GetIncidentId();

        const TIncidentsManager& incidentManager = context.GetServer()->GetDriveAPI()->GetIncidentsManager();
        auto prevIncidentState = incidentManager.GetPreviousIncidentState(incidentId, session);
        if (!prevIncidentState) {
            return false;
        }

        DestinationStatus = prevIncidentState->GetStatus();
        return true;
    }
}
