#pragma once

#include <drive/backend/incident/constants.h>
#include <drive/backend/incident/states.h>

#include <util/string/cast.h>

namespace NDrive {
    class TReopenIncidentTransition: public IBaseIncidentTransition {
        FACTORY_INCIDENT_TRANSITION(TReopenIncidentTransition, EIncidentTransition::Reopen);

    public:
        virtual TSet<EIncidentStatus> GetAllowedSourceStatuses() const override;
        virtual EIncidentStatus GetDestinationStatus(const TIncidentStateContext& context) const override;

    private:
        virtual bool DoPerform(TIncidentStateContext& context, NDrive::TEntitySession& session) const override;

    private:
        R_OPTIONAL(EIncidentStatus, DestinationStatus, {}, mutable);
    };
}
