#include "update_data.h"

#include <rtline/library/json/merge.h>

namespace NDrive {
    TUpdateDataIncidentTransition::TRegistrator TUpdateDataIncidentTransition::Registrator;

    NDrive::TScheme TUpdateDataIncidentTransition::GetScheme(const TIncidentStateContext& context) const {
        return TIncidentData::GetInitialScheme(context.OptionalInstance());
    }

    bool TUpdateDataIncidentTransition::Initialize(const NJson::TJsonValue& data, const TIncidentStateContext& context, TMessagesCollector& errors) {
        Data = NJson::UnnestJson(data);

        EIncidentType dataIncidentType;
        if (context.HasInstance() && data.Has("incident_type")) {
            if (!NJson::ParseField(Data["incident_type"], NJson::Stringify(dataIncidentType), /* required = */ true, errors)) {
                return false;
            }
            if (context.OptionalInstance()->GetIncidentType() != dataIncidentType) {
                errors.AddMessage(__LOCATION__, "Incident type change is forbidden");
                return false;
            }
        }

        return true;
    }

    TSet<EIncidentStatus> TUpdateDataIncidentTransition::GetAllowedSourceStatuses() const {
        return { EIncidentStatus::New };
    }

    EIncidentStatus TUpdateDataIncidentTransition::GetDestinationStatus(const TIncidentStateContext& context) const {
        return context.GetCurrentStatus();
    }

    bool TUpdateDataIncidentTransition::DoPerform(TIncidentStateContext& context, NDrive::TEntitySession& session) const {
        TMessagesCollector errors;
        if (!context.MutableInstance()->DeserializeDataFromJson(Data, errors)) {
            session.SetErrorInfo(TIncidentData::GetTableName(), errors.GetStringReport(), EDriveSessionResult::IncorrectRequest);
            return false;
        }
        return true;
    }
}
