#pragma once

#include <drive/backend/incident/constants.h>
#include <drive/backend/incident/states.h>

#include <util/string/cast.h>

namespace NDrive {
    class TUpdateDataIncidentTransition: public IBaseIncidentTransition {
        FACTORY_INCIDENT_TRANSITION(TUpdateDataIncidentTransition, EIncidentTransition::UpdateData);

    public:
        virtual NDrive::TScheme GetScheme(const TIncidentStateContext& context) const override;
        virtual bool Initialize(const NJson::TJsonValue& data, const TIncidentStateContext& context, TMessagesCollector& errors) override;

        virtual TSet<EIncidentStatus> GetAllowedSourceStatuses() const override;
        virtual EIncidentStatus GetDestinationStatus(const TIncidentStateContext& context) const override;

    private:
        virtual bool DoPerform(TIncidentStateContext& context, NDrive::TEntitySession& session) const override;

    private:
        R_READONLY(NJson::TJsonValue, Data);
    };
}
