#include "objects.h"


namespace NDrive {
    double TInsuranceInfo::GetFinalCost(bool withBase) const {
        return GetCost(withBase) * 0.01;
    }

    ui64 TInsuranceInfo::GetCost(bool withBase) const {
        TDuration time = EndTime - StartTime;
        ui64 minutes = time.Minutes();
        if (time > TDuration::Minutes(minutes)) {
            minutes += 1;
        }
        return minutes * Policy.GetPerMinuteCost() + (withBase ? Policy.GetBaseCost() : 0);
    }
}
