#pragma once

#include <drive/backend/car_attachments/documents/insurance.h>

#include <rtline/util/types/accessor.h>

namespace NDrive {
    struct TInsuranceInfo {
    public:
        R_FIELD(TInstant, StartTime);
        R_FIELD(TInstant, EndTime);
        R_FIELD(TString, VIN);
        R_FIELD(TString, CarModel);
        R_FIELD(TString, SessionId);

        R_READONLY(ui64, TaskId, 0);
        R_READONLY(TCarInsurancePolicy, Policy);

    public:
        TInsuranceInfo(ui64 taskId, const TCarInsurancePolicy& policy)
            : TaskId(taskId)
            , Policy(policy)
        {}

        TString GetKey() const {
            return SessionId + "-" + ::ToString(TaskId);
        }

        double GetFinalCost(bool withBase) const;
        ui64 GetCost(bool withBase) const;
    };
}
