#pragma once

#include <drive/backend/insurance/abstract/objects.h>

#include <rtline/library/deprecated/async_impl/async_impl.h>

namespace NDrive {

    class TIngosClientConfig {
        R_READONLY(TAsyncApiImpl::TConfig, AuthModuleConfig);       //ssotest.ingos.ru

        R_READONLY(TAsyncApiImpl::TConfig, ClientConfig);       //test-gate.ingos.ru


        R_READONLY(TString, AuthPath, "blitz/auth-service/te");
        R_READONLY(TString, PutRidesPath, "api/carsharing/carsharingWebApi/v1/rides");
        R_READONLY(TString, SecretFile);
        R_READONLY(TString, AuthSecret);

    public:
        void Init(const TYandexConfig::Section* section, const TMap<TString, NSimpleMeta::TConfig>* requestPolicy);
        void ToString(IOutputStream& os) const;
    };

    class TIngosClient {
        class TAuthClient {
        public:
            TAuthClient(const TIngosClientConfig& config);
            bool RefreshToken(TDuration reqTimeout, bool force = false);
            TString GetAuthToken() const;
        private:
            const TIngosClientConfig& Config;
            TAsyncApiImpl Impl;
            TMutex TokenLock;
            TString AuthToken;
            TInstant NextRefresh = TInstant::Zero();
        };
    public:

        TIngosClient(const TIngosClientConfig& config)
            : Config(config)
            , AuthModule(Config)
            , Impl(Config.GetClientConfig(), "ingos_api")
        {}

        bool PushData(TVector<TInsuranceInfo>& ridings, TDuration reqTimeout, bool withBaseCost, const std::function<void(bool, const TInsuranceInfo&)>& callback) const;
    private:
        TIngosClientConfig Config;
        mutable TAuthClient AuthModule;
        TAsyncApiImpl Impl;
   };
}
