#pragma once

#include <drive/backend/insurance/abstract/objects.h>

#include <rtline/library/deprecated/async_impl/async_impl.h>

namespace NDrive {
    class TReninsClientConfig : public TAsyncApiImpl::TConfig {
        R_READONLY(TString, RequestPolicyName);
        R_READONLY(TString, ApiPath);
        R_READONLY(TString, ListApiPath);

    public:
        void Init(const TYandexConfig::Section* section, const TMap<TString, NSimpleMeta::TConfig>* requestPolicy);
        void ToString(IOutputStream& os) const;
    };

    class TReninsClient {
    public:
        TReninsClient(const TReninsClientConfig& config);
        void PushData(const TVector<TInsuranceInfo>& segments, ui32 atOnce, TDuration reqTimeout, bool withBaseCost, const std::function<void(bool, const TInsuranceInfo&)>& callback) const;
        void PushDataPack(const TVector<TInsuranceInfo>& segments, TDuration reqTimeout, bool withBaseCost, const std::function<void(bool, const TInsuranceInfo&)>& callback) const;

    private:
        TReninsClientConfig Config;
        TAsyncApiImpl Impl;
   };
}
