#include "builder.h"

#include <drive/backend/abstract/frontend.h>
#include <drive/backend/cars/hardware.h>
#include <drive/backend/database/drive_api.h>

bool TInsuranceTasksCompilation::Fill(const TVector<TTimeEvent>& timeline, const TVector<TAtomicSharedPtr<TCarTagHistoryEvent>>& events) {
    RideIntervals.clear();
    TAtomicSharedPtr<TCarTagHistoryEvent> ridingStart = nullptr;
    for (ui32 i = 0; i < timeline.size(); ++i) {
        if (timeline[i].GetTimeEvent() == IEventsSession<TCarTagHistoryEvent>::EEvent::Tag) {
            TAtomicSharedPtr<TCarTagHistoryEvent> currentEvent = events[timeline[i].GetEventIndex()];
            Y_ENSURE(currentEvent);
            if (ridingStart) {
                ui32 actionEventId = currentEvent->GetHistoryEventId();
                if (actionEventId > MinAcceptedId && actionEventId <= MaxAcceptedId) {
                    RideIntervals.emplace_back(ridingStart, currentEvent);
                }
                ridingStart = nullptr;
            }
            if ((*currentEvent)->GetName() == "old_state_riding") { // TChargableTag::Riding
                if (!ridingStart) {
                    ridingStart = currentEvent;
                }
            }
        }
    }
    return true;
}

TMaybe<TCarInsurancePolicy> GetInsurancePolicy(const TString& objectId, TInstant timestamp, const NDrive::IServer& server) {
    auto api = server.GetDriveAPI();
    auto result = TCarInsurancePolicy();
    if (!Yensured(api)->GetCarAttachmentAssignments().GetEffectiveInsurancePolicy(objectId, timestamp, result)) {
        return {};
    }
    return result;
}
