#pragma once

#include <drive/backend/database/history/session.h>
#include <drive/backend/tags/tags.h>

class TCarInsurancePolicy;

class TInsuranceTasksCompilation: public IEventsSession<TCarTagHistoryEvent>::ICompilation {
public:
    using TRidingSegment = std::pair<TAtomicSharedPtr<TCarTagHistoryEvent>, TAtomicSharedPtr<TCarTagHistoryEvent>>;
    using TTimeEvent = IEventsSession<TCarTagHistoryEvent>::TTimeEvent;

public:
    R_FIELD(ui32, MinAcceptedId, 0);
    R_FIELD(ui32, MaxAcceptedId, Max<ui32>());
    R_FIELD(TVector<TRidingSegment>, RideIntervals, {});

public:
    virtual NJson::TJsonValue GetReport(ELocalization /*locale*/, const NDrive::IServer* /*server*/, ISessionReportCustomization::TPtr /*customization*/) const override {
        ythrow yexception() << "unimplemented";
    }

    virtual const TString& GetSessionId() const override {
        ythrow yexception() << "unimplemented";
    }

    virtual bool Fill(const TVector<TTimeEvent>& timeline, const TVector<TAtomicSharedPtr<TCarTagHistoryEvent>>& events) override;
};

TMaybe<TCarInsurancePolicy> GetInsurancePolicy(const TString& objectId, TInstant timestamp, const NDrive::IServer& server);
