#include "builder.h"

#include <drive/backend/offers/actions/ut/library/helper.h>

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(InsuranceTaskBuilder) {
    Y_UNIT_TEST(Simple) {
        TCarTagHistoryEventConstructor eventBase;
        eventBase.SetObjectId("object").SetTagId("1").SetHistoryUserId("user");
        TBillingSession session;
        AddEvent(session, eventBase, "old_state_reservation", TInstant::Seconds(1000), EObjectHistoryAction::SetTagPerformer);
        AddEvent(session, eventBase, "old_state_acceptance", TInstant::Seconds(1020), EObjectHistoryAction::TagEvolve);
        AddEvent(session, eventBase, "old_state_riding", TInstant::Seconds(1040), EObjectHistoryAction::TagEvolve);
        AddEvent(session, eventBase, "old_state_parking", TInstant::Seconds(1140), EObjectHistoryAction::TagEvolve);
        AddEvent(session, eventBase, "old_state_riding", TInstant::Seconds(1240), EObjectHistoryAction::TagEvolve);
        AddEvent(session, eventBase, "old_state_reservation", TInstant::Seconds(1340), EObjectHistoryAction::TagEvolve);
        AddEvent(session, eventBase, "old_state_reservation", TInstant::Seconds(1341), EObjectHistoryAction::DropTagPerformer);

        TInsuranceTasksCompilation compilation;
        UNIT_ASSERT(session.FillCompilation(compilation));

        const auto& intervals = compilation.GetRideIntervals();
        UNIT_ASSERT_VALUES_EQUAL(intervals.size(), 2);
        UNIT_ASSERT_VALUES_EQUAL(intervals[0].first->GetHistoryInstant(), TInstant::Seconds(1040));
        UNIT_ASSERT_VALUES_EQUAL(intervals[0].second->GetHistoryInstant(), TInstant::Seconds(1140));
        UNIT_ASSERT_VALUES_EQUAL(intervals[1].first->GetHistoryInstant(), TInstant::Seconds(1240));
        UNIT_ASSERT_VALUES_EQUAL(intervals[1].second->GetHistoryInstant(), TInstant::Seconds(1340));
    }

    Y_UNIT_TEST(ZeroDiff) {
        TCarTagHistoryEventConstructor eventBase;
        eventBase.SetObjectId("object").SetTagId("1").SetHistoryUserId("user");
        TBillingSession session;
        AddEvent(session, eventBase, "old_state_reservation", TInstant::Seconds(1000), EObjectHistoryAction::SetTagPerformer);
        AddEvent(session, eventBase, "old_state_acceptance", TInstant::Seconds(1020), EObjectHistoryAction::TagEvolve);
        AddEvent(session, eventBase, "old_state_riding", TInstant::Seconds(1040), EObjectHistoryAction::TagEvolve);
        AddEvent(session, eventBase, "old_state_riding", TInstant::Seconds(1090), EObjectHistoryAction::TagEvolve);
        AddEvent(session, eventBase, "old_state_parking", TInstant::Seconds(1140), EObjectHistoryAction::TagEvolve);
        AddEvent(session, eventBase, "old_state_riding", TInstant::Seconds(1240), EObjectHistoryAction::TagEvolve);
        AddEvent(session, eventBase, "old_state_reservation", TInstant::Seconds(1340), EObjectHistoryAction::TagEvolve);
        AddEvent(session, eventBase, "old_state_reservation", TInstant::Seconds(1341), EObjectHistoryAction::DropTagPerformer);

        TInsuranceTasksCompilation compilation;
        UNIT_ASSERT(session.FillCompilation(compilation));

        const auto& intervals = compilation.GetRideIntervals();
        UNIT_ASSERT_VALUES_EQUAL(intervals.size(), 3);
        UNIT_ASSERT_VALUES_EQUAL(intervals[0].first->GetHistoryInstant(), TInstant::Seconds(1040));
        UNIT_ASSERT_VALUES_EQUAL(intervals[0].second->GetHistoryInstant(), TInstant::Seconds(1090));
        UNIT_ASSERT_VALUES_EQUAL(intervals[1].first->GetHistoryInstant(), TInstant::Seconds(1090));
        UNIT_ASSERT_VALUES_EQUAL(intervals[1].second->GetHistoryInstant(), TInstant::Seconds(1140));
    }
}
