#pragma once

#include <drive/backend/database/history/manager.h>

class ITagsHistoryContext;

class TInsuranceNotification {
public:
    R_FIELD(ui64, NotificationId, Max<ui64>());
    R_FIELD(TInstant, Start, TInstant::Zero());
    R_FIELD(TInstant, Finish, TInstant::Zero());
    R_FIELD(TString, UserId);
    R_FIELD(TString, CarId);
    R_FIELD(TString, SessionId);

public:
    class TDecoder: public TBaseDecoder {
        R_FIELD(i32, NotificationId, -1);
        R_FIELD(i32, Start, -1);
        R_FIELD(i32, Finish, -1);
        R_FIELD(i32, UserId, -1);
        R_FIELD(i32, CarId, -1);
        R_FIELD(i32, SessionId, -1);

    public:
        TDecoder() = default;
        TDecoder(const TMap<TString, ui32>& decoderBase);
    };

public:
    TInsuranceNotification() = default;

    bool DeserializeWithDecoder(const TDecoder& decoder, const TConstArrayRef<TStringBuf>& values, const IHistoryContext* /*hContext*/);
    bool DeserializeFromTableRecord(const NStorage::TTableRecord& record, const ITagsHistoryContext* /*context*/);
    NStorage::TTableRecord SerializeToTableRecord() const;
};
using TInsuranceNotifications = TVector<TInsuranceNotification>;

class TProcessedInsuranceNotification: public TInsuranceNotification {
public:
    R_FIELD(TInstant, Created);
    R_FIELD(TInstant, Sent);

public:
    TProcessedInsuranceNotification(const TInsuranceNotification& notification)
        : TInsuranceNotification(notification)
    {
    }
};

class TInsuranceHistoryManager: public TDatabaseHistoryManager<TInsuranceNotification> {
private:
    using TBase = TDatabaseHistoryManager<TInsuranceNotification>;

    using TNotifications = TVector<TProcessedInsuranceNotification>;
    using TOptionalNotifications = TMaybe<TNotifications>;

public:
    TInsuranceHistoryManager(const IHistoryContext& context)
        : TBase(context, "insurance_tasks_history")
    {
    }

    TOptionalNotifications GetSession(const TString& sessionId, NDrive::TEntitySession& tx) const;
};
