#include "split.h"

#include "history.h"

TInsuranceNotifications NDrive::Split(const TInsuranceNotification& notification, const TTimeRestrictionsPool<TTimeRestriction>& timetable) {
    TInsuranceNotifications result;
    auto start = notification.GetStart();
    auto finish = notification.GetFinish();
    auto split = start;
    while (split < finish) {
        auto part = notification;
        part.SetStart(split);
        split = timetable.GetNextCorrectionTime(split);
        auto shiftedSplit = split - TDuration::Seconds(1);
        part.SetFinish(std::min(shiftedSplit, finish));
        result.push_back(std::move(part));
    }
    return result;
}
