#include "split.h"

#include "history.h"

#include <rtline/library/json/adapters.h>

#include <library/cpp/testing/unittest/registar.h>

namespace {
    auto timetableString = R"(
        {
            "time_zone": 3,
            "restrictions": [
                {
                    "time_to": 600,
                    "time_from": 0
                }
            ]
        }
    )";
    auto timetableSerialized = NJson::ToJson(NJson::JsonString(timetableString));
    auto timetable = NJson::FromJson<TTimeRestrictionsPool<TTimeRestriction>>(timetableSerialized);
}

Y_UNIT_TEST_SUITE(InsuranceNotificationSplit) {
    Y_UNIT_TEST(Simple) {
        TInsuranceNotification notification;
        notification.SetStart(TInstant::Seconds(1617981094));
        notification.SetFinish(TInstant::Seconds(1617981094 + 86400));
        notification.SetCarId("car_id");
        notification.SetSessionId("session_id");
        notification.SetUserId("user_id");
        auto ns = NDrive::Split(notification, timetable);
        UNIT_ASSERT_VALUES_EQUAL(ns.size(), 3);

        TMaybe<TInstant> finish;
        for (auto&& n : ns) {
            Cerr << n.GetStart() << " " << n.GetFinish() << Endl;
            if (finish) {
                UNIT_ASSERT_VALUES_EQUAL(finish, n.GetStart() - TDuration::Seconds(1));
            }
            finish = n.GetFinish();
            UNIT_ASSERT_VALUES_EQUAL(n.GetCarId(), notification.GetCarId());
            UNIT_ASSERT_VALUES_EQUAL(n.GetSessionId(), notification.GetSessionId());
            UNIT_ASSERT_VALUES_EQUAL(n.GetUserId(), notification.GetUserId());
        }
        UNIT_ASSERT_VALUES_EQUAL(finish, notification.GetFinish());
    }
}
