#include "config.h"
#include <library/cpp/mediator/global_notifications/system_status.h>

void TLocalizationConfig::Init(const TYandexConfig::Section* section) {
    auto children = section->GetAllChildren();
    DBName = section->GetDirectives().Value("DBName", DBName);
    AssertCorrectConfig(!!DBName, "Incorrect database for localization");
    HistoryConfig.SetDeep(TDuration::Days(365));
    if (auto it = children.find("History"); it != children.end()) {
        HistoryConfig.Init(it->second);
    }
    if (auto it = children.find("Propositions"); it != children.end()) {
        PropositionsConfig.Init(it->second);
    }

    TString locale;
    if (section->GetDirectives().GetValue("DefaultLocale", locale)) {
        DefaultLocale = FromStringWithDefault<ELocalization>(locale, DefaultLocale);
    }
    DefaultLocalePreffered = section->GetDirectives().Value("DefaultLocalePreffered", DefaultLocalePreffered);
}

void TLocalizationConfig::ToString(IOutputStream& os) const {
    os << "DBName: " << DBName << Endl;
    os << "DefaultLocale: " << DefaultLocale << Endl;
    os << "DefaultLocalePreffered: " << DefaultLocalePreffered << Endl;

    os << "<History>" << Endl;
    HistoryConfig.ToString(os);
    os << "</History>" << Endl;
    os << "<Propositions>" << Endl;
    PropositionsConfig.ToString(os);
    os << "</Propositions>" << Endl;
}
