#pragma once

#include <drive/backend/database/history/config.h>
#include <drive/backend/database/history/propositions.h>

#include <library/cpp/yconf/conf.h>

#include <rtline/util/types/accessor.h>

#include <util/datetime/base.h>

class TLocalizationConfig {
private:
    R_READONLY(TString, DBName);
    R_READONLY(THistoryConfig, HistoryConfig);
    R_READONLY(TPropositionsManagerConfig, PropositionsConfig);
    R_READONLY(bool, DefaultLocalePreffered, false);

public:
    void Init(const TYandexConfig::Section* section);

    void ToString(IOutputStream& os) const;
};
