#pragma once

#include <rtline/library/unistat/signals.h>

#include <library/cpp/http/misc/httpcodes.h>
#include <library/cpp/unistat/unistat.h>

#include <util/generic/string.h>

class IReplyContext;

class TReplyInfo {
private:
    const ui32 Code;
    const TDuration Duration;
public:
    TReplyInfo(const ui32 code, const TDuration duration)
        : Code(code)
        , Duration(duration)
    {
    }

    ui32 GetCode() const {
        return Code;
    }

    TDuration GetDuration() const {
        return Duration;
    }
};

namespace NDrive {

class TUnistatSignals {
private:
    class TInitializer {
    public:
        void AddSignal(const TString& signalName) {
            SignalsNames.push_back(signalName);
        }

    public:
        void Init(TUnistat& unistat) const {
            for (auto&& signalName: SignalsNames) {
                unistat.DrillFloatHole(signalName, "dmmm", NUnistat::TPriority(50));
            }
        }

    private:
        TVector<TString> SignalsNames;
    };

private:
    static TEnumSignal<HttpCodes, double> CodesMeter;
    static TEnumSignal<HttpCodes, double> CodesTimes;
    static TSignalByKey<TString, TReplyInfo> ServiceSignalsReply;
    static TSignalByKey<TString, double> ServiceSignalsAccess;
    static TSignalByKey<TString, double> ServiceSignalsTimeouted;

public:
    static void RegisterFallback();
    static void RegisterSignals(const TString& processorName);
    static void OnAccess(const TString& processorName);
    static void OnReply(const TString& processorName, HttpCodes code, const IReplyContext& context);
    static void OnReply(const TString& processorName, HttpCodes code, TInstant start, TInstant finish, TInstant deadline);
};

}
