#pragma once

#include <rtline/library/storage/structured.h>

class TMaintenanceInfo {
public:
    using TId = TString;

    class TDecoder: public TBaseDecoder {
        R_FIELD(i32, VIN, -1);
        R_FIELD(i32, Mileage, -1);
        R_FIELD(i32, StartDate, -1);
        R_FIELD(i32, ReadyDate, -1);
        R_FIELD(i32, Source, -1);
        R_FIELD(i32, Intermediate, -1);

    public:
        TDecoder() = default;
        TDecoder(const TMap<TString, ui32>& decoderBase);
    };

public:
    static TString GetTableName() {
        return "maintenance_info";
    }

    static TString GetHistoryTableName() {
        return "maintenance_info_history";
    }

    bool operator!() const {
        return false;
    }

public:
    NJson::TJsonValue SerializeToJson() const;
    bool Parse(const NJson::TJsonValue& info);
    bool DeserializeFromJson(const NJson::TJsonValue& info);
    NStorage::TTableRecord SerializeToTableRecord() const;
    bool IsEqual(const TMaintenanceInfo& info) const;
    bool operator<(const TMaintenanceInfo& item) const;
    bool DeserializeWithDecoder(const TDecoder& decoder, const TConstArrayRef<TStringBuf>& values, const IHistoryContext* /*hContext*/);

public:
    static const TString InternalSource;

private:
    R_FIELD(TString, VIN);
    R_OPTIONAL(double, Mileage);
    R_FIELD(TInstant, StartDate, TInstant::Zero());
    R_OPTIONAL(TInstant, ReadyDate);
    R_FIELD(TString, Source, InternalSource);
    R_FIELD(bool, Intermediate, false);
};
